package fr.asip.cps3.exemple.modele.jni;

import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;

public interface TraitementsSpecifiques {

	/**
	 * Initialise la librairie
	 * @throws PKCS11Exception
	 */
	public void initialiseLibrairie() throws PKCS11Exception;		
	
	/**
	 * Traitement spcifique d'etat connexion carte
	 * @throws PKCS11Exception
	 */
	public void etatConnexionCarte() throws PKCS11Exception;
	
	/**
	 * Guide l'utilisateur pour s'authentifier sur une carte
	 * @throws PKCS11Exception
	 */
	public void assistantAuthentification() throws PKCS11Exception;	

	/**
	 * Guide l'utilisateur pour constater l'tat de saisie du code porteur
	 * @throws PKCS11Exception
	 */
	public void etatSaisieCodePorteur() throws PKCS11Exception;		

	/**
	 * Traitement spcifique de recyclage du code porteur
	 * @throws PKCS11Exception
	 */
	public void recyclageCodePorteur() throws PKCS11Exception;			

	/**
	 * Traitement spcifique d'authentification aprs retrait carte
	 * @throws PKCS11Exception
	 */
	public void authentificationApresRetraitCarte() throws PKCS11Exception;

	/**
	 * Traitement spcifique d'authentification aprs retrait lecteur
	 * @throws PKCS11Exception
	 */
	public void authentificationApresRetraitLecteur() throws PKCS11Exception;
	
	
	/**
	 * Traitement spcifique de lecture d'un objet de donnes applicatives (jeton)
	 *
	 * @return tableau d'octets contenant la valeur de l'attribut de l'objet
	 * @throws PKCS11Exception
	 */
	public byte[] lectureObjetDonneesApplicatives() throws PKCS11Exception;
	
	/**
	 * Traitement spcifique de modification d'un objet de donnes applicatives (jeton)
	 * 
	 * @return tableau d'octets contenant la valeur de l'attribut de l'objet
	 * @throws PKCS11Exception
	 */
	public byte[] modificationObjetDonneesApplicatives() throws PKCS11Exception;
	
	/**
	 * Indique si la librairie JNI est bien liee et initialisee
	 */
	public boolean estInitialisee();
	
	/**
	 * Indique si la librairie PKCS#11 est non nulle
	 */
	public boolean estLibrairieDefinie();
	
	/**
	 * Accesseur
	 * @return Code porteur saisi
	 */
	public char[] getCodePorteur();
	
	/**
	 * Mutateur
	 * @param codePorteur Code porteur saisi
	 */
	public void setCodePorteur(char[] codePorteur);

}
